/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.analysis.sonarapi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sonar.api.batch.rule.ActiveRule;
import org.sonar.api.batch.rule.ActiveRules;
import org.sonar.api.rule.RuleKey;
import org.sonarsource.sonarlint.core.analysis.sonarapi.ActiveRuleAdapter;

public class ActiveRulesAdapter
implements ActiveRules {
    private final Collection<ActiveRule> allActiveRules;
    private final Map<String, List<ActiveRule>> activeRulesByRepository = new HashMap<String, List<ActiveRule>>();
    private final Map<String, List<ActiveRule>> activeRulesByLanguage = new HashMap<String, List<ActiveRule>>();
    private final Map<String, Map<String, ActiveRule>> activeRulesByRepositoryAndKey = new HashMap<String, Map<String, ActiveRule>>();
    private final Map<String, Map<String, ActiveRule>> activeRulesByRepositoryAndInternalKey = new HashMap<String, Map<String, ActiveRule>>();

    public ActiveRulesAdapter(Collection<ActiveRuleAdapter> activeRules) {
        this.allActiveRules = List.copyOf(activeRules);
        for (ActiveRule r : this.allActiveRules) {
            if (r.internalKey() != null) {
                this.activeRulesByRepositoryAndInternalKey.computeIfAbsent(r.ruleKey().repository(), x -> new HashMap()).put(r.internalKey(), r);
            }
            this.activeRulesByRepositoryAndKey.computeIfAbsent(r.ruleKey().repository(), x -> new HashMap()).put(r.ruleKey().rule(), r);
            this.activeRulesByRepository.computeIfAbsent(r.ruleKey().repository(), x -> new ArrayList()).add(r);
            this.activeRulesByLanguage.computeIfAbsent(r.language(), x -> new ArrayList()).add(r);
        }
    }

    @Override
    public ActiveRule find(RuleKey ruleKey) {
        return (ActiveRule)this.activeRulesByRepositoryAndKey.getOrDefault(ruleKey.repository(), Collections.emptyMap()).get(ruleKey.rule());
    }

    @Override
    public Collection<ActiveRule> findAll() {
        return this.allActiveRules;
    }

    @Override
    public Collection<ActiveRule> findByRepository(String repository) {
        return this.activeRulesByRepository.getOrDefault(repository, Collections.emptyList());
    }

    @Override
    public Collection<ActiveRule> findByLanguage(String language) {
        return this.activeRulesByLanguage.getOrDefault(language, Collections.emptyList());
    }

    @Override
    public ActiveRule findByInternalKey(String repository, String internalKey) {
        return this.activeRulesByRepositoryAndInternalKey.containsKey(repository) ? this.activeRulesByRepositoryAndInternalKey.get(repository).get(internalKey) : null;
    }
}

