/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.embedded.server;

import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.io.HttpRequestHandler;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.sonarsource.sonarlint.core.clientapi.SonarLintClient;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.ClientInfoDto;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.clientapi.client.info.GetClientInfoResponse;
import org.sonarsource.sonarlint.core.repository.connection.ConnectionConfigurationRepository;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;
import org.sonarsource.sonarlint.shaded.com.google.gson.annotations.Expose;

@Named
@Singleton
public class StatusRequestHandler
implements HttpRequestHandler {
    private final SonarLintClient client;
    private final ConnectionConfigurationRepository repository;
    private final ClientInfoDto clientInfo;

    public StatusRequestHandler(SonarLintClient client, ConnectionConfigurationRepository repository, InitializeParams params) {
        this.client = client;
        this.repository = repository;
        this.clientInfo = params.getClientInfo();
    }

    public void handle(ClassicHttpRequest request, ClassicHttpResponse response, HttpContext context) throws HttpException, IOException {
        if (!Method.GET.isSame(request.getMethod())) {
            response.setCode(400);
            return;
        }
        boolean trustedServer = Optional.ofNullable(request.getHeader("Origin")).map(NameValuePair::getValue).map(this::isTrustedServer).orElse(false);
        this.getDescription(trustedServer).thenAccept(description -> response.setEntity((HttpEntity)new StringEntity(new Gson().toJson(new StatusResponse(this.clientInfo.getName(), (String)description, !trustedServer)), ContentType.APPLICATION_JSON)));
    }

    private CompletableFuture<String> getDescription(boolean trustedServer) {
        if (trustedServer) {
            return this.client.getClientInfo().thenApply(GetClientInfoResponse::getDescription);
        }
        return CompletableFuture.completedFuture("");
    }

    private boolean isTrustedServer(String serverOrigin) {
        return this.repository.hasConnectionWithOrigin(serverOrigin);
    }

    private static class StatusResponse {
        @Expose
        private final String ideName;
        @Expose
        private final String description;
        @Expose
        private final boolean needsToken;

        public StatusResponse(String ideName, String description, boolean needsToken) {
            this.ideName = ideName;
            this.description = description;
            this.needsToken = needsToken;
        }
    }
}

