/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.languages;

import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.backend.initialize.InitializeParams;
import org.sonarsource.sonarlint.core.commons.Language;

@Named
@Singleton
public class LanguageSupportRepository {
    private static final EnumSet<Language> LANGUAGES_RAISING_TAINT_VULNERABILITIES = EnumSet.of(Language.CS, new Language[]{Language.JAVA, Language.JS, Language.TS, Language.PHP, Language.PYTHON});
    private final EnumSet<Language> enabledLanguagesInStandaloneMode;
    private final EnumSet<Language> enabledLanguagesInConnectedMode;

    public LanguageSupportRepository(InitializeParams params) {
        this.enabledLanguagesInStandaloneMode = LanguageSupportRepository.toEnumSet(params.getEnabledLanguagesInStandaloneMode(), Language.class);
        this.enabledLanguagesInConnectedMode = EnumSet.copyOf(this.enabledLanguagesInStandaloneMode);
        this.enabledLanguagesInConnectedMode.addAll(params.getExtraEnabledLanguagesInConnectedMode());
    }

    private static <T extends Enum<T>> EnumSet<T> toEnumSet(Collection<T> collection, Class<T> clazz) {
        return collection.isEmpty() ? EnumSet.noneOf(clazz) : EnumSet.copyOf(collection);
    }

    public Set<Language> getEnabledLanguagesInStandaloneMode() {
        return this.enabledLanguagesInStandaloneMode;
    }

    public Set<Language> getEnabledLanguagesInConnectedMode() {
        return this.enabledLanguagesInConnectedMode;
    }

    public boolean areTaintVulnerabilitiesSupported() {
        EnumSet<Language> intersection = EnumSet.copyOf(LANGUAGES_RAISING_TAINT_VULNERABILITIES);
        intersection.retainAll(this.enabledLanguagesInConnectedMode);
        return !intersection.isEmpty();
    }
}

