/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.newcode;

import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonarsource.sonarlint.core.clientapi.backend.newcode.GetNewCodeDefinitionParams;
import org.sonarsource.sonarlint.core.clientapi.backend.newcode.GetNewCodeDefinitionResponse;
import org.sonarsource.sonarlint.core.clientapi.backend.newcode.NewCodeService;
import org.sonarsource.sonarlint.core.commons.Binding;
import org.sonarsource.sonarlint.core.commons.NewCodeDefinition;
import org.sonarsource.sonarlint.core.repository.config.ConfigurationRepository;
import org.sonarsource.sonarlint.core.serverconnection.SonarProjectStorage;
import org.sonarsource.sonarlint.core.storage.StorageService;
import org.sonarsource.sonarlint.core.telemetry.TelemetryServiceImpl;

@Named
@Singleton
public class NewCodeServiceImpl
implements NewCodeService {
    private final ConfigurationRepository configurationRepository;
    private final StorageService storageService;
    private final TelemetryServiceImpl telemetryService;

    public NewCodeServiceImpl(ConfigurationRepository configurationRepository, StorageService storageService, TelemetryServiceImpl telemetryService) {
        this.configurationRepository = configurationRepository;
        this.storageService = storageService;
        this.telemetryService = telemetryService;
    }

    @Override
    public CompletableFuture<GetNewCodeDefinitionResponse> getNewCodeDefinition(GetNewCodeDefinitionParams params) {
        String configScopeId = params.getConfigScopeId();
        return this.getFullNewCodeDefinition(configScopeId).map(newCodeDefinition -> CompletableFuture.completedFuture(new GetNewCodeDefinitionResponse(newCodeDefinition.toString(), newCodeDefinition.isSupported()))).orElse(CompletableFuture.completedFuture(new GetNewCodeDefinitionResponse("No new code definition found", false)));
    }

    public Optional<NewCodeDefinition> getFullNewCodeDefinition(String configScopeId) {
        Optional<Binding> effectiveBinding = this.configurationRepository.getEffectiveBinding(configScopeId);
        if (effectiveBinding.isEmpty()) {
            return Optional.empty();
        }
        Binding binding = effectiveBinding.get();
        SonarProjectStorage sonarProjectStorage = this.storageService.binding(binding);
        return sonarProjectStorage.newCodeDefinition().read();
    }

    @Override
    public void didToggleFocus() {
        this.telemetryService.newCodeFocusChanged();
    }
}

