/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverapi.plugins;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;
import org.sonarsource.sonarlint.core.serverapi.ServerApiHelper;
import org.sonarsource.sonarlint.core.serverapi.plugins.ServerPlugin;
import org.sonarsource.sonarlint.shaded.com.google.gson.Gson;

public class PluginsApi {
    private static final SonarLintLogger LOG = SonarLintLogger.get();
    private final ServerApiHelper helper;

    public PluginsApi(ServerApiHelper helper) {
        this.helper = helper;
    }

    public List<ServerPlugin> getInstalled() {
        return ServerApiHelper.processTimed(() -> this.helper.get("/api/plugins/installed"), response -> {
            InstalledPluginsPayload plugins = new Gson().fromJson(response.bodyAsString(), InstalledPluginsPayload.class);
            return Arrays.stream(plugins.plugins).map(PluginsApi::toInstalledPlugin).collect(Collectors.toList());
        }, duration -> LOG.info("Downloaded plugin list in {}ms", (Object)duration));
    }

    private static ServerPlugin toInstalledPlugin(InstalledPluginPayload payload) {
        return new ServerPlugin(payload.key, payload.hash, payload.filename, payload.sonarLintSupported);
    }

    public void getPlugin(String key, ServerApiHelper.IOConsumer<InputStream> pluginFileConsumer) {
        String url = "api/plugins/download?plugin=" + key;
        ServerApiHelper.consumeTimed(() -> this.helper.get(url), response -> pluginFileConsumer.accept(response.bodyAsStream()), duration -> LOG.info("Downloaded '{}' in {}ms", (Object)key, (Object)duration));
    }

    static class InstalledPluginPayload {
        String key;
        String hash;
        String filename;
        boolean sonarLintSupported;

        InstalledPluginPayload() {
        }
    }

    private static class InstalledPluginsPayload {
        InstalledPluginPayload[] plugins;

        private InstalledPluginsPayload() {
        }
    }
}

