/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection;

import java.util.Objects;
import java.util.Optional;

public class ProjectBinding {
    private final String projectKey;
    private final String serverPathPrefix;
    private final String idePathPrefix;

    public ProjectBinding(String projectKey, String serverPathPrefix, String idePathPrefix) {
        this.projectKey = projectKey;
        this.serverPathPrefix = serverPathPrefix;
        this.idePathPrefix = idePathPrefix;
    }

    public String projectKey() {
        return this.projectKey;
    }

    public String serverPathPrefix() {
        return this.serverPathPrefix;
    }

    public String idePathPrefix() {
        return this.idePathPrefix;
    }

    public Optional<String> serverPathToIdePath(String serverPath) {
        Object actualLocalPrefix;
        if (!serverPath.startsWith(this.serverPathPrefix())) {
            return Optional.empty();
        }
        int localPrefixLen = this.serverPathPrefix().length();
        if (localPrefixLen > 0) {
            ++localPrefixLen;
        }
        if (!((String)(actualLocalPrefix = this.idePathPrefix())).isEmpty()) {
            actualLocalPrefix = (String)actualLocalPrefix + "/";
        }
        return Optional.of((String)actualLocalPrefix + serverPath.substring(localPrefixLen));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectBinding that = (ProjectBinding)o;
        return Objects.equals(this.projectKey, that.projectKey) && Objects.equals(this.serverPathPrefix, that.serverPathPrefix) && Objects.equals(this.idePathPrefix, that.idePathPrefix);
    }

    public int hashCode() {
        return Objects.hash(this.projectKey, this.serverPathPrefix, this.idePathPrefix);
    }
}

