/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.prefix;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;

class ReversePathTree {
    private final Node root = new MultipleChildrenNode();

    ReversePathTree() {
    }

    public void index(Path path) {
        Node parent = null;
        Node currentNode = this.root;
        Path currentNodePath = null;
        for (int i = path.getNameCount() - 1; i >= 0; --i) {
            Path childNodePath = path.getName(i);
            Node[] result = currentNode.computeChildrenIfAbsent(parent, currentNodePath, childNodePath);
            parent = result[0];
            currentNode = result[1];
            currentNodePath = childNodePath;
        }
        currentNode.setTerminal(true);
    }

    public Match findLongestSuffixMatches(Path path) {
        Path nextEl;
        Node nextNode;
        int matchLen;
        Node currentNode = this.root;
        for (matchLen = 0; matchLen < path.getNameCount() && (nextNode = currentNode.getChild(nextEl = path.getName(path.getNameCount() - matchLen - 1))) != null; ++matchLen) {
            currentNode = nextNode;
        }
        return ReversePathTree.collectAllPrefixes(currentNode, matchLen);
    }

    private static Match collectAllPrefixes(Node node, int matchLen) {
        ArrayList<Path> paths = new ArrayList<Path>();
        if (matchLen > 0) {
            ReversePathTree.collectPrefixes(node, Paths.get("", new String[0]), paths);
        }
        return new Match(paths, matchLen);
    }

    private static void collectPrefixes(Node node, Path currentPath, List<Path> paths) {
        if (node.isTerminal()) {
            paths.add(currentPath);
        }
        for (Map.Entry<Path, Node> child : node.childrenEntrySet()) {
            Path childPath = child.getKey().resolve(currentPath);
            ReversePathTree.collectPrefixes(child.getValue(), childPath, paths);
        }
    }

    public static class Match {
        private final List<Path> paths;
        private final int matchLen;

        private Match(List<Path> paths, int matchLen) {
            this.paths = paths;
            this.matchLen = matchLen;
        }

        public List<Path> matchPrefixes() {
            return this.paths;
        }

        public int matchLen() {
            return this.matchLen;
        }
    }

    private static class MultipleChildrenNode
    extends AbstractNode {
        private final Map<Path, Node> children = new HashMap<Path, Node>();

        private MultipleChildrenNode() {
        }

        @Override
        public Node[] computeChildrenIfAbsent(Node parent, Path currentNodePath, Path childNodePath) {
            return new Node[]{this, this.children.computeIfAbsent(childNodePath, e -> new SingleChildNode())};
        }

        @Override
        public Set<Map.Entry<Path, Node>> childrenEntrySet() {
            return this.children.entrySet();
        }

        @Override
        @CheckForNull
        public Node getChild(Path name) {
            return this.children.get(name);
        }

        @Override
        public void put(Path path, Node node) {
            this.children.put(path, node);
        }
    }

    private static class SingleChildNode
    extends AbstractNode {
        @Nullable
        private Path singleChildKey;
        @Nullable
        private Node singleChildValue;

        private SingleChildNode() {
        }

        @Override
        public Node[] computeChildrenIfAbsent(Node parent, Path currentNodePath, Path childNodePath) {
            if (this.singleChildKey == null) {
                this.put(childNodePath, new SingleChildNode());
                return new Node[]{this, this.singleChildValue};
            }
            if (childNodePath.equals(this.singleChildKey)) {
                return new Node[]{this, this.singleChildValue};
            }
            SingleChildNode child = new SingleChildNode();
            MultipleChildrenNode replacement = new MultipleChildrenNode();
            replacement.put(this.singleChildKey, this.singleChildValue);
            replacement.put(childNodePath, child);
            parent.put(currentNodePath, replacement);
            return new Node[]{replacement, child};
        }

        @Override
        public Set<Map.Entry<Path, Node>> childrenEntrySet() {
            if (this.singleChildKey == null) {
                return Collections.emptySet();
            }
            return Collections.singleton(new AbstractMap.SimpleEntry<Path, Node>(this.singleChildKey, this.singleChildValue));
        }

        @Override
        public void put(Path path, Node node) {
            this.singleChildKey = path;
            this.singleChildValue = node;
        }

        @Override
        @CheckForNull
        public Node getChild(Path name) {
            return name.equals(this.singleChildKey) ? this.singleChildValue : null;
        }
    }

    private static abstract class AbstractNode
    implements Node {
        private boolean terminal;

        private AbstractNode() {
        }

        @Override
        public final boolean isTerminal() {
            return this.terminal;
        }

        @Override
        public final void setTerminal(boolean b) {
            this.terminal = b;
        }
    }

    private static interface Node {
        public Node[] computeChildrenIfAbsent(Node var1, Path var2, Path var3);

        public Set<Map.Entry<Path, Node>> childrenEntrySet();

        public Node getChild(Path var1);

        public void setTerminal(boolean var1);

        public boolean isTerminal();

        public void put(Path var1, Node var2);
    }
}

