/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.serverconnection.storage;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.sonarsource.sonarlint.shaded.org.apache.commons.compress.archivers.ArchiveEntry;
import org.sonarsource.sonarlint.shaded.org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.sonarsource.sonarlint.shaded.org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.sonarsource.sonarlint.shaded.org.apache.commons.compress.utils.IOUtils;

public class TarGzUtils {
    private TarGzUtils() {
    }

    public static void extractTarGz(Path tarGzFile, Path destinationDir) throws IOException {
        try (InputStream fi = Files.newInputStream(tarGzFile, new OpenOption[0]);
             BufferedInputStream bi = new BufferedInputStream(fi);
             GzipCompressorInputStream gzi = new GzipCompressorInputStream(bi);
             TarArchiveInputStream o = new TarArchiveInputStream(gzi);){
            ArchiveEntry entry = null;
            while ((entry = o.getNextEntry()) != null) {
                if (!o.canReadEntryData(entry)) {
                    throw new IllegalStateException("Unable to read entry data from " + tarGzFile);
                }
                Path f = TarGzUtils.fileName(destinationDir, entry);
                if (entry.isDirectory()) {
                    Files.createDirectories(f, new FileAttribute[0]);
                    continue;
                }
                Path parent = f.getParent();
                Files.createDirectories(parent, new FileAttribute[0]);
                OutputStream os = Files.newOutputStream(f, new OpenOption[0]);
                try {
                    IOUtils.copy(o, os);
                }
                finally {
                    if (os == null) continue;
                    os.close();
                }
            }
        }
    }

    private static Path fileName(Path destinationDir, ArchiveEntry zipEntry) throws IOException {
        Path destFile = destinationDir.resolve(zipEntry.getName());
        if (!destFile.normalize().startsWith(destinationDir)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destFile;
    }
}

