/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.telemetry;

import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import org.sonarsource.sonarlint.shaded.com.google.gson.TypeAdapter;
import org.sonarsource.sonarlint.shaded.com.google.gson.stream.JsonReader;
import org.sonarsource.sonarlint.shaded.com.google.gson.stream.JsonWriter;

public class OffsetDateTimeAdapter
extends TypeAdapter<OffsetDateTime> {
    private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    @Override
    public void write(JsonWriter jsonWriter, OffsetDateTime offsetDateTime) throws IOException {
        jsonWriter.value(FORMATTER.format(offsetDateTime));
    }

    @Override
    public OffsetDateTime read(JsonReader jsonReader) throws IOException {
        return OffsetDateTime.parse(jsonReader.nextString(), FORMATTER);
    }
}

