/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.utils;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;
import org.sonarsource.sonarlint.core.commons.log.SonarLintLogger;

public class FutureUtils {
    private static final long WAITING_FREQUENCY = 100L;
    private static final SonarLintLogger LOG = SonarLintLogger.get();

    public static void waitForTask(CancelChecker cancelChecker, Future<?> task, String taskName, Duration timeoutDuration) {
        try {
            FutureUtils.waitForFutureWithTimeout(cancelChecker, task, timeoutDuration);
        }
        catch (TimeoutException ex) {
            task.cancel(true);
            LOG.error(taskName + " task expired", ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        catch (Exception ex) {
            LOG.error(taskName + " task failed", ex);
        }
    }

    public static void waitForTasks(CancelChecker indicator, List<Future<?>> tasks, String taskName, Duration timeoutDuration) {
        for (Future<?> f : tasks) {
            FutureUtils.waitForTask(indicator, f, taskName, timeoutDuration);
        }
    }

    private static void waitForFutureWithTimeout(CancelChecker cancelChecker, Future<?> future, Duration durationTimeout) throws InterruptedException, ExecutionException, TimeoutException {
        for (long counter = 0L; counter < durationTimeout.toMillis(); counter += 100L) {
            if (cancelChecker.isCanceled()) {
                future.cancel(true);
                return;
            }
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException ignored) {
                continue;
            }
            catch (InterruptedException | CancellationException e) {
                throw new InterruptedException("Interrupted");
            }
        }
        throw new TimeoutException();
    }

    private FutureUtils() {
    }
}

