/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.IUtilityIndex;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.SimpleCrudIndex;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.RunnableWithException;
import org.jetbrains.annotations.VisibleForTesting;

public class BidirectionalListIndexBase<K extends Comparable<K>, V extends Comparable<V>>
extends IndexBase
implements IUtilityIndex {
    private static final String LOCK_FOR_CONSISTENCY = "lockForConsistency";
    private final SimpleCrudIndex<K, ArrayList<V>> forwardIndex;
    protected static final String FORWARD_INDEX_ID = "f";
    private final SimpleCrudIndex<V, ArrayList<K>> backwardIndex;
    private static final String BACKWARD_INDEX_ID = "b";
    public static final byte[] FORWARD_INDEX_KEY_PREFIX = DelegatingPartitionStore.buildStoragePathPrefix("f");

    public BidirectionalListIndexBase(IStore store, ISerializer<K, byte[]> keySerializer, ISerializer<V, byte[]> valueSerializer, ISerializer<ArrayList<K>, byte[]> listOfKeysSerializer, ISerializer<ArrayList<V>, byte[]> listOfValuesSerializer) {
        super(store, false);
        this.forwardIndex = new SimpleCrudIndex<K, ArrayList<ArrayList<V>>>(new DelegatingPartitionStore(store, FORWARD_INDEX_ID), keySerializer, listOfValuesSerializer);
        this.backwardIndex = new SimpleCrudIndex<ArrayList<K>, ArrayList<V>>(new DelegatingPartitionStore(store, BACKWARD_INDEX_ID), valueSerializer, listOfKeysSerializer);
    }

    public Set<V> updateValues(Map<K, ArrayList<V>> updatedEntries, List<K> removedKeys) throws StorageException {
        BidirectionalListIndexBase.checkThatParametersAreDisjunct(updatedEntries, removedKeys);
        HashSet deletesInBackwardIndex = new HashSet();
        RunnableWithException updateValuesRunnable = () -> deletesInBackwardIndex.addAll(this.updateValuesInternal(updatedEntries, removedKeys));
        this.store.performWithLock((RunnableWithException<StorageException>)updateValuesRunnable, LOCK_FOR_CONSISTENCY);
        return deletesInBackwardIndex;
    }

    private Set<V> updateValuesInternal(Map<K, ArrayList<V>> updatedEntries, List<K> removedKeys) throws StorageException {
        Map<V, ArrayList<K>> updatedBackwardsSlice = this.computeUpdatedBackwardIndexSlice(updatedEntries, removedKeys);
        HashMap<Comparable, ArrayList<K>> updatedBackwardsSliceWithoutEmptyLists = new HashMap<Comparable, ArrayList<K>>();
        HashSet<Comparable> deletesInBackwardIndex = new HashSet<Comparable>();
        for (Map.Entry<V, ArrayList<K>> entry : updatedBackwardsSlice.entrySet()) {
            Comparable value = (Comparable)entry.getKey();
            ArrayList<K> keys = entry.getValue();
            if (keys.isEmpty()) {
                deletesInBackwardIndex.add(value);
                continue;
            }
            updatedBackwardsSliceWithoutEmptyLists.put(value, keys);
        }
        updatedBackwardsSlice.values().forEach(Collections::sort);
        this.backwardIndex.put(PairList.fromMap(updatedBackwardsSliceWithoutEmptyLists));
        this.backwardIndex.remove((Collection<V>)deletesInBackwardIndex);
        updatedEntries.values().forEach(Collections::sort);
        this.forwardIndex.put(PairList.fromMap(updatedEntries));
        this.forwardIndex.remove((Collection<K>)removedKeys);
        return deletesInBackwardIndex;
    }

    private Map<V, ArrayList<K>> computeUpdatedBackwardIndexSlice(Map<K, ArrayList<V>> updatedEntries, List<K> removedKeys) throws StorageException {
        ArrayList<K> changedKeys = new ArrayList<K>(updatedEntries.keySet());
        changedKeys.addAll(removedKeys);
        Map<K, ArrayList<V>> valuesPreviouslyAssociatedWithKeys = this.getForwardValuesByKeys(changedKeys);
        HashSet relevantBackwardsValues = new HashSet();
        updatedEntries.values().stream().flatMap(Collection::stream).forEach(relevantBackwardsValues::add);
        valuesPreviouslyAssociatedWithKeys.values().stream().flatMap(Collection::stream).forEach(relevantBackwardsValues::add);
        Map updatedBackwardsSlice = this.getBackwardKeysByValues(relevantBackwardsValues);
        BidirectionalListIndexBase.updateBackwardIndexSliceForChangedEntries(updatedEntries, valuesPreviouslyAssociatedWithKeys, updatedBackwardsSlice);
        BidirectionalListIndexBase.updateBackwardIndexSliceForDeletedKeys(removedKeys, valuesPreviouslyAssociatedWithKeys, updatedBackwardsSlice);
        return updatedBackwardsSlice;
    }

    private static <K extends Comparable<K>, V extends Comparable<V>> void updateBackwardIndexSliceForChangedEntries(Map<K, ArrayList<V>> updatedEntries, Map<K, ArrayList<V>> valuesPreviouslyAssociatedWithKeys, Map<V, ArrayList<K>> updatedBackwardsSlice) {
        for (Map.Entry<K, ArrayList<V>> entry : updatedEntries.entrySet()) {
            ArrayList associatedKeys;
            Comparable updatedEntryKey = (Comparable)entry.getKey();
            ArrayList<V> updatedEntryValues = entry.getValue();
            ArrayList<V> valuesPreviouslyAssociatedWithKey = valuesPreviouslyAssociatedWithKeys.get(updatedEntryKey);
            if (valuesPreviouslyAssociatedWithKey != null) {
                for (Comparable valuePreviouslyAssociatedWithKey : valuesPreviouslyAssociatedWithKey) {
                    associatedKeys = updatedBackwardsSlice.get(valuePreviouslyAssociatedWithKey);
                    associatedKeys.remove(updatedEntryKey);
                }
            }
            for (Comparable newAssociatedValue : updatedEntryValues) {
                associatedKeys = updatedBackwardsSlice.computeIfAbsent((ArrayList)((Object)newAssociatedValue), (Function<ArrayList, ArrayList<Comparable>>)((Function<Comparable, ArrayList>)v -> new ArrayList()));
                associatedKeys.add(updatedEntryKey);
            }
        }
    }

    private static <K extends Comparable<K>, V extends Comparable<V>> void updateBackwardIndexSliceForDeletedKeys(List<K> removedKeys, Map<K, ArrayList<V>> valuesPreviouslyAssociatedWithKeys, Map<V, ArrayList<K>> updatedBackwardsSlice) {
        for (Comparable removedKey : removedKeys) {
            ArrayList<V> valuesPreviouslyAssociatedWithKey = valuesPreviouslyAssociatedWithKeys.get(removedKey);
            if (valuesPreviouslyAssociatedWithKey == null) continue;
            for (Comparable valuePreviouslyAssociatedWithKey : valuesPreviouslyAssociatedWithKey) {
                ArrayList<K> associatedKeys = updatedBackwardsSlice.get(valuePreviouslyAssociatedWithKey);
                associatedKeys.remove(removedKey);
            }
        }
    }

    private static <K extends Comparable<K>, V extends Comparable<V>> void checkThatParametersAreDisjunct(Map<K, ArrayList<V>> updatedEntries, List<K> removedKeys) {
        for (Comparable removedKey : removedKeys) {
            if (!updatedEntries.containsKey(removedKey)) continue;
            throw new IllegalArgumentException("Key " + String.valueOf(removedKey) + " is also contained in updated entries (with value " + String.valueOf(updatedEntries.get(removedKey)) + ")");
        }
    }

    public void removeValues(List<V> valuesToBeRemoved) throws StorageException {
        List<@Nullable ArrayList<K>> associatedKeys = this.backwardIndex.get((SequencedCollection<V>)valuesToBeRemoved);
        HashSet<K> keysToUpdate = new HashSet<K>();
        for (int i = 0; i < valuesToBeRemoved.size(); ++i) {
            @Nullable ArrayList<K> previouslyAssociatedKeys = associatedKeys.get(i);
            if (previouslyAssociatedKeys == null) {
                valuesToBeRemoved.remove(i);
                --i;
                continue;
            }
            keysToUpdate.addAll(previouslyAssociatedKeys);
        }
        Map forwardIndexSlice = this.getForwardValuesByKeys(new ArrayList(keysToUpdate));
        HashSet<Comparable> keysToRemove = new HashSet<Comparable>();
        for (int i = 0; i < valuesToBeRemoved.size(); ++i) {
            Comparable valueToBeRemoved = (Comparable)valuesToBeRemoved.get(i);
            @Nullable ArrayList<K> previouslyAssociatedKeys = associatedKeys.get(i);
            for (Comparable previouslyAssociatedKey : previouslyAssociatedKeys) {
                ArrayList<V> values = forwardIndexSlice.get(previouslyAssociatedKey);
                values.remove(valueToBeRemoved);
                if (!values.isEmpty()) continue;
                forwardIndexSlice.remove(previouslyAssociatedKey);
                keysToRemove.add(previouslyAssociatedKey);
            }
        }
        this.forwardIndex.put(PairList.fromMap(forwardIndexSlice));
        this.forwardIndex.remove(keysToRemove);
        this.backwardIndex.remove((Collection<V>)valuesToBeRemoved);
    }

    public Set<K> getKeysThatShareValuesWith(List<K> keys) throws StorageException {
        LinkedHashSet relevantValues = new LinkedHashSet();
        this.forwardIndex.get((SequencedCollection<K>)keys).stream().filter(Objects::nonNull).forEach(relevantValues::addAll);
        HashSet associatedKeys = new HashSet();
        this.backwardIndex.get(relevantValues).forEach(associatedKeys::addAll);
        return associatedKeys;
    }

    public List<ArrayList<V>> getValuesForKeys(List<K> keys) throws StorageException {
        return this.forwardIndex.get((SequencedCollection<K>)keys);
    }

    public List<@Nullable ArrayList<K>> getKeysForValues(List<V> values) throws StorageException {
        return this.backwardIndex.get((SequencedCollection<V>)values);
    }

    public Map<K, ArrayList<V>> getAllForwardEntries() throws StorageException {
        return this.forwardIndex.getEntries().toMap();
    }

    public Map<V, ArrayList<K>> getAllBackwardEntries() throws StorageException {
        return this.backwardIndex.getEntries().toMap();
    }

    private Map<K, ArrayList<V>> getForwardValuesByKeys(List<K> keys) throws StorageException {
        List<ArrayList<V>> values = this.forwardIndex.get((SequencedCollection<K>)keys);
        HashMap<Comparable, ArrayList<V>> result = new HashMap<Comparable, ArrayList<V>>(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            if (values.get(i) == null) continue;
            result.put((Comparable)keys.get(i), values.get(i));
        }
        return result;
    }

    private Map<V, ArrayList<K>> getBackwardKeysByValues(Collection<V> values) throws StorageException {
        return this.getBackwardKeysByValues((List<V>)new ArrayList<V>(values));
    }

    private Map<V, ArrayList<K>> getBackwardKeysByValues(List<V> values) throws StorageException {
        List<ArrayList<K>> keys = this.backwardIndex.get((SequencedCollection<V>)values);
        HashMap<Comparable, ArrayList<K>> result = new HashMap<Comparable, ArrayList<K>>(values.size());
        for (int i = 0; i < values.size(); ++i) {
            if (keys.get(i) == null) continue;
            result.put((Comparable)values.get(i), keys.get(i));
        }
        return result;
    }

    @VisibleForTesting
    public @NonNull List<String> validateIndexConsistency() throws StorageException {
        Map<K, ArrayList<V>> forwardEntries = this.getAllForwardEntries();
        Map<V, ArrayList<K>> backwardEntries = this.getAllBackwardEntries();
        ArrayList<String> inconsistencies = new ArrayList<String>();
        for (Map.Entry<K, ArrayList<V>> entry : forwardEntries.entrySet()) {
            Comparable key = (Comparable)entry.getKey();
            ArrayList<V> values = entry.getValue();
            for (Comparable comparable : values) {
                ArrayList<K> keys = backwardEntries.get(comparable);
                if (keys == null) {
                    inconsistencies.add("forward has `" + String.valueOf(key) + "`->`" + String.valueOf(comparable) + "` but backward has no entries for the second item");
                    continue;
                }
                if (keys.contains(key)) continue;
                inconsistencies.add("forward has `" + String.valueOf(key) + "`->`" + String.valueOf(comparable) + "` but backward has no corresponding entry");
            }
        }
        for (Map.Entry<Object, ArrayList<Object>> entry : backwardEntries.entrySet()) {
            Comparable value = (Comparable)entry.getKey();
            ArrayList<Object> keys = entry.getValue();
            for (Comparable comparable : keys) {
                ArrayList<V> values = forwardEntries.get(comparable);
                if (values == null) {
                    inconsistencies.add("backward has `" + String.valueOf(value) + "`->`" + String.valueOf(comparable) + "` but forward has no entries for the second item");
                    continue;
                }
                if (values.contains(value)) continue;
                inconsistencies.add("backward has `" + String.valueOf(value) + "`->`" + String.valueOf(comparable) + "` but forward has no corresponding entry");
            }
        }
        return inconsistencies;
    }

    @Override
    public IStore getWrappedStore() {
        return this.store.getWrappedStore();
    }
}

