/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.IKeyedObjectDescriber;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class KeyedObjectDescriberBase<T>
implements IKeyedObjectDescriber<T> {
    private final TreeMap<String, EKeyedObjectType> fieldTypes = new TreeMap(String.CASE_INSENSITIVE_ORDER);

    public static Comparator<String> getComparator(EKeyedObjectType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case EKeyedObjectType.NUMBER -> KeyedObjectDescriberBase.numberComparator();
            case EKeyedObjectType.NUMBER_LIST -> KeyedObjectDescriberBase.listComparator(KeyedObjectDescriberBase.numberComparator());
            case EKeyedObjectType.STRING_LIST -> KeyedObjectDescriberBase.listComparator(KeyedObjectDescriberBase.stringComparator());
            case EKeyedObjectType.DATE, EKeyedObjectType.NUMBER_MAP, EKeyedObjectType.STRING_MAP, EKeyedObjectType.STRING -> KeyedObjectDescriberBase.stringComparator();
        };
    }

    private static Comparator<String> listComparator(Comparator<String> elementComparator) {
        return Comparator.comparing(value -> StringUtils.splitToList((String)value, (String)","), CollectionUtils.getListComparator(elementComparator));
    }

    private static Comparator<String> stringComparator() {
        return Comparator.comparing(String::toLowerCase);
    }

    private static Comparator<String> numberComparator() {
        return Comparator.comparing(StringUtils::nullIfEmpty, Comparator.nullsFirst(Comparator.comparing(BigDecimal::new)));
    }

    @Override
    public List<String> getUnmanagedKeys() {
        return Collections.emptyList();
    }

    @Override
    public EKeyedObjectType getType(String key) {
        if (this.fieldTypes.containsKey(key)) {
            return this.fieldTypes.get(key);
        }
        return EKeyedObjectType.STRING;
    }

    @Override
    public synchronized void addFieldTypeMappings(Map<String, EKeyedObjectType> fieldTypes) {
        this.fieldTypes.putAll(fieldTypes);
    }

    @Override
    public byte[] serialize(T t) throws StorageException {
        return StorageUtils.serialize((Serializable)t);
    }

    @Override
    public T deserialize(byte[] value) throws StorageException {
        return StorageUtils.deserialize(value);
    }

    protected final ValueDescriber describerWithNaturalOrder(Function<T, String> accessor) {
        return new ValueDescriber(this, accessor, Comparator.comparing(accessor, Comparator.nullsLast(Comparator.naturalOrder())));
    }

    protected class ValueDescriber {
        private final Function<T, String> accessor;
        private final Comparator<T> comparator;

        public ValueDescriber(KeyedObjectDescriberBase this$0, Function<? super T, String> accessor, Comparator<? super T> comparator) {
            CCSMAssert.isNotNull(accessor, () -> String.format("Expected \"%s\" to be not null", "accessor"));
            CCSMAssert.isNotNull(comparator, () -> String.format("Expected \"%s\" to be not null", "comparator"));
            this.accessor = accessor;
            this.comparator = comparator;
        }

        public Function<T, String> getAccessor() {
            return this.accessor;
        }

        public Comparator<T> getComparator() {
            return this.comparator;
        }
    }
}

