/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.autocomplete;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.AutocompletionResult;
import org.conqat.engine.persistence.index.keyed.query.autocomplete.QueryAutocompletionHelper;
import org.conqat.engine.persistence.index.keyed.query.error.QueryParsingException;
import org.conqat.engine.persistence.index.keyed.query.lexer.EQueryTokenType;
import org.conqat.lib.commons.collections.CollectionUtils;

public abstract class QueryAutocompleterBase {
    private static final Pattern VALID_IDENTIFIER_PATTERN = Pattern.compile("[\\p{L}\\p{Digit}-]+(\\(\\))?");
    private static final Pattern ESCAPED_CHARACTER_PATTERN = Pattern.compile("['\\\\]");
    private final int maxSuggestions;

    protected QueryAutocompleterBase(int maxSuggestions) {
        this.maxSuggestions = maxSuggestions;
    }

    protected abstract List<String> getAttributesStartingWith(String var1);

    protected abstract List<String> getValuesStartingWith(String var1, String var2);

    protected abstract List<String> getFunctionArgumentsStartingWith(EQueryTokenType var1, int var2, String var3);

    public AutocompletionResult getSuggestions(String query) {
        try {
            QueryAutocompletionHelper suggester = new QueryAutocompletionHelper(this, query);
            List<String> suggestions = suggester.getSuggestions();
            suggestions = CollectionUtils.sort(suggestions, (lhs, rhs) -> {
                String sanitizedLhs = StringUtils.unwrap((String)lhs, (String)"'");
                String sanitizedRhs = StringUtils.unwrap((String)rhs, (String)"'");
                return sanitizedLhs.compareToIgnoreCase(sanitizedRhs);
            });
            if (suggestions.size() > this.maxSuggestions) {
                suggestions = suggestions.subList(0, this.maxSuggestions);
            }
            suggestions = CollectionUtils.map((Collection)suggestions, QueryAutocompleterBase::escapeSuggestions);
            return new AutocompletionResult(suggestions, suggester.getCompletionRemovalSize());
        }
        catch (QueryParsingException e) {
            return new AutocompletionResult(Collections.emptyList(), 0);
        }
    }

    private static String escapeSuggestions(String value) {
        if (VALID_IDENTIFIER_PATTERN.matcher(value).matches() && !StringUtils.equals((CharSequence)value, (CharSequence)"currentUser()")) {
            return value;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("'");
        Matcher matcher = ESCAPED_CHARACTER_PATTERN.matcher(value);
        while (matcher.find()) {
            matcher.appendReplacement(builder, "\\" + matcher.group());
        }
        matcher.appendTail(builder);
        builder.append("'");
        return builder.toString();
    }
}

