/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.index.keyed.query.tree;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.engine.persistence.index.keyed.query.error.QueryCompilationException;
import org.conqat.engine.persistence.index.keyed.query.tree.IAttributeOperand;
import org.conqat.engine.persistence.index.keyed.query.tree.ICompilationContext;

public abstract class NumericAggregationFunctionBase<I>
implements IAttributeOperand {
    private final IAttributeOperand attribute;
    private final String functionName;

    protected NumericAggregationFunctionBase(String functionName, IAttributeOperand attribute) {
        this.functionName = functionName;
        this.attribute = attribute;
    }

    protected EnumSet<EKeyedObjectType> getAllowedInputTypes() {
        return EnumSet.of(EKeyedObjectType.NUMBER_LIST);
    }

    @Override
    public <T> EKeyedObjectType getType(ICompilationContext<T> context) throws QueryCompilationException {
        return EKeyedObjectType.NUMBER;
    }

    @Override
    public <T> Function<T, Object> getValueAccessor(ICompilationContext<T> context) throws QueryCompilationException {
        EKeyedObjectType type = this.attribute.getType(context);
        if (!this.getAllowedInputTypes().contains((Object)type)) {
            throw new QueryCompilationException(this.functionName + " can only be performed on " + this.getAllowedInputTypes().toString() + ", but got: " + String.valueOf((Object)type), this.functionName);
        }
        Function accessor = this.attribute.getValueAccessor(context);
        return object -> this.aggregateList((List)accessor.apply(object));
    }

    @Override
    public <T> Predicate<T> getValueEqualsIgnoreCasePredicate(ICompilationContext<T> context, Object comparisonValue, boolean lenient) throws QueryCompilationException {
        return this.getValueAccessor(context).andThen(String::valueOf).andThen(IAttributeOperand.stringComparer(String.valueOf(comparisonValue), lenient)::test)::apply;
    }

    protected abstract Long aggregateList(List<I> var1);

    public String toString() {
        return this.functionName + "(" + this.attribute.toString() + ")";
    }
}

