/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.crypto;

import javax.crypto.spec.SecretKeySpec;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.crypto.EncryptedStorageHandler;
import org.conqat.engine.persistence.store.util.AbstractValueTransformingStore;

public class EncryptingStore
extends AbstractValueTransformingStore {
    private final SecretKeySpec key = EncryptedStorageHandler.getPrimaryKey();

    public EncryptingStore(IStore store) {
        super(store);
    }

    @Override
    protected byte[] reverseTransformation(byte[] value) throws StorageException {
        return EncryptedStorageHandler.decrypt(value, this.key);
    }

    @Override
    protected byte[] applyTransformation(byte[] value) throws StorageException {
        return EncryptedStorageHandler.encrypt(value, this.key);
    }
}

