/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.readcache;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.LongAdder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.DelegatingStore;
import org.conqat.engine.persistence.store.readcache.ICache;
import org.conqat.lib.commons.collections.PairList;
import org.jetbrains.annotations.VisibleForTesting;

class ReadCachingStore
extends DelegatingStore {
    private final ICache<byte[], byte[]> cache;
    private final LongAdder hitCount = new LongAdder();
    private final LongAdder missCount = new LongAdder();

    public ReadCachingStore(IStore store, ICache<byte[], byte[]> cache) {
        super(store);
        this.cache = cache;
    }

    @VisibleForTesting
    void clearReference(byte[] key) {
        this.invalidateCache(key);
    }

    @Override
    public byte[] get(byte @NonNull [] key) throws StorageException {
        byte[] value;
        ICache.CacheValue<byte[]> cacheValue = this.cache.get(key);
        if (cacheValue != null) {
            this.hitCount.increment();
            value = cacheValue.value();
        } else {
            this.missCount.increment();
            value = super.get(key);
            this.cache.put(key, value);
        }
        return ReadCachingStore.safeCloneArray(value);
    }

    private static byte[] safeCloneArray(byte[] array) {
        if (array == null) {
            return null;
        }
        return (byte[])array.clone();
    }

    @Override
    public List<byte[]> get(List<byte @NonNull []> keys) throws StorageException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        ArrayList<byte[]> missingKeys = new ArrayList<byte[]>();
        ArrayList<Integer> missingIndexes = new ArrayList<Integer>();
        for (int i = 0; i < keys.size(); ++i) {
            ICache.CacheValue<byte[]> cacheValue = this.cache.get(keys.get(i));
            if (cacheValue != null) {
                result.add(ReadCachingStore.safeCloneArray(cacheValue.value()));
                continue;
            }
            result.add(null);
            missingKeys.add(keys.get(i));
            missingIndexes.add(i);
        }
        if (missingKeys.isEmpty()) {
            this.hitCount.increment();
        } else {
            this.missCount.increment();
            List<byte[]> missingValues = super.get(missingKeys);
            for (int i = 0; i < missingKeys.size(); ++i) {
                result.set((Integer)missingIndexes.get(i), ReadCachingStore.safeCloneArray(missingValues.get(i)));
                this.cache.put((byte[])missingKeys.get(i), missingValues.get(i));
            }
        }
        return result;
    }

    @Override
    public void remove(byte @NonNull [] key) throws StorageException {
        this.invalidateCache(key);
        super.remove(key);
    }

    @Override
    public void remove(List<byte @NonNull []> keys) throws StorageException {
        this.invalidateCache(keys);
        super.remove(keys);
    }

    @Override
    public void removeByPrefix(byte @NonNull [] prefix) throws StorageException {
        this.invalidateFullCache();
        super.removeByPrefix(prefix);
    }

    @Override
    public void put(byte @NonNull [] key, byte @NonNull [] value) throws StorageException {
        this.invalidateCache(key);
        super.put(key, value);
    }

    @Override
    public void put(PairList<byte @NonNull [], byte @NonNull []> keysValues) throws StorageException {
        this.invalidateCache(keysValues.extractFirstList());
        super.put(keysValues);
    }

    private void invalidateCache(byte[] key) {
        this.cache.remove(key);
    }

    private void invalidateCache(List<byte[]> keys) {
        this.cache.remove(keys);
    }

    void invalidateFullCache() {
        this.cache.removeAll();
    }

    public String getHitAndMissStatistics() {
        return "Hits: " + String.valueOf(this.hitCount) + ", Misses: " + String.valueOf(this.missCount);
    }
}

