/*
 * Decompiled with CFR 0.152.
 */
package org.conqat.engine.persistence.store.util;

import org.conqat.engine.persistence.store.IStorageSystem;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.base.StorageSystemBase;
import org.conqat.engine.persistence.store.util.DelegatingPartitionStore;
import org.conqat.engine.persistence.store.util.StorageSystemIdManager;

public class PartitionedStorageSystem {
    private final IStorageSystem storageSystem;

    public PartitionedStorageSystem(IStorageSystem storageSystem) {
        this.storageSystem = storageSystem;
    }

    public IStorageSystem getPartition(String partitionName) throws StorageException {
        return new SingleStoreBasedStorageSystem(this.storageSystem.openStore(partitionName), StorageSystemIdManager.getInstance().getOrCreateId(this.storageSystem.getStorageSystemId() + ":" + partitionName));
    }

    public void removePartition(String partitionName) throws StorageException {
        StorageSystemIdManager.getInstance().removeStorageSystem(this.storageSystem.getStorageSystemId() + ":" + partitionName);
        this.storageSystem.removeStore(partitionName);
    }

    public static class SingleStoreBasedStorageSystem
    extends StorageSystemBase {
        private final IStore baseStore;

        public SingleStoreBasedStorageSystem(IStore baseStore, int storageSystemId) {
            super(storageSystemId);
            this.baseStore = baseStore;
        }

        @Override
        public IStore openStore(String name) {
            return new DelegatingPartitionStore(this.baseStore, name);
        }
    }
}

