

This plugin test checks for the unsafe usage of the ``yaml.load`` function from
the PyYAML package. The yaml.load function provides the ability to construct
an arbitrary Python object, which may be dangerous if you receive a YAML
document from an untrusted source. The function yaml.safe_load limits this
ability to simple Python objects like integers or lists.

Please see
https://pyyaml.org/wiki/PyYAMLDocumentation#LoadingYAML for more information
on ``yaml.load`` and yaml.safe_load

## Example

``` python

>> Issue: [yaml_load] Use of unsafe yaml load. Allows instantiation of
arbitrary objects. Consider yaml.safe_load().
Severity: Medium   Confidence: High
CWE: CWE-20 (https://cwe.mitre.org/data/definitions/20.html)
Location: examples/yaml_load.py:5
4 ystr = yaml.dump({'a' : 1, 'b' : 2, 'c' : 3})
5 y = yaml.load(ystr)
6 yaml.dump(y)

```
## see also:

- https://pyyaml.org/wiki/PyYAMLDocumentation#LoadingYAML
- https://cwe.mitre.org/data/definitions/20.html

New in version  1.0.0

Changed in version  1.7.3
CWE information added

