### SCS0015 - Hardcoded Password 

The password configuration to this API appears to be hardcoded.

#### Risk

If hard-coded passwords are used, it is almost certain that malicious users will gain access through the account in question.

#### Vulnerable Code

```cs
config.setPassword("NotSoSecr3tP@ssword");

```

#### Solution

It is recommended to externalize configuration such as password to avoid leakage of secret information. The source code or its binary form is more likely to be accessible by an attacker than a production configuration. To be managed safely, passwords and secret keys should be stored encrypted in separate configuration files. The certificate for decryption should be installed as non-exportable on the server machine.

Configuration file :

```xml
<configuration>
    <appSettings>
    <add key="api_password" value="b3e521073ca276dc2b7caf6247b6ddc72d5e2d2d" />
  </appSettings>
</configuration>

```

Code:

```cs
string apiPassword = ConfigurationManager.AppSettings["api_password"];
config.setPassword(apiPassword);

```

#### References

[CWE-259: Use of Hard-coded Password](https://cwe.mitre.org/data/definitions/259.html)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)