### SCS0018 - Path Traversal 

A path traversal attack (also known as directory traversal) aims to access files and directories that are stored outside the expected directory.By manipulating variables that reference files with “dot-dot-slash (../)” sequences and its variations or by using absolute file paths, it may be possible to access arbitrary files and directories stored on file system including application source code or configuration and critical system files.

#### Risk

With a malicious relative path, an attacker could reach a secret file.

#### Vulnerable Code

```cs
[RedirectingAction]
public ActionResult Download(string fileName)
{
    byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/ClientDocument/") + fileName);
    return File(fileBytes, System.Net.Mime.MediaTypeNames.Application.Octet, fileName);
}

```

The following request downloads a file of the attacker choice:`http://www.address.com/Home/Download?fileName=../../somefile.txt`

#### Solution

Do not try to strip invalid characters. Fail if any unexpected character is detected.

```cs
private static readonly char[] InvalidFilenameChars = Path.GetInvalidFileNameChars();

[RedirectingAction]
public ActionResult Download(string fileName)
{
    if (fileName.IndexOfAny(InvalidFilenameChars) >= 0)
        return new HttpStatusCodeResult(HttpStatusCode.BadRequest);
        
    byte[] fileBytes = System.IO.File.ReadAllBytes(Server.MapPath("~/ClientDocument/") + fileName);
    return File(fileBytes, System.Net.Mime.MediaTypeNames.Application.Octet, fileName);
}

```

If the input is not supplied by user or a validation is in place the warning can be suppressed.

#### References

[CWE-22: Improper Limitation of a Pathname to a Restricted Directory (‘Path Traversal’)](https://cwe.mitre.org/data/definitions/22.html)  
[OWASP: Path Traversal](https://www.owasp.org/index.php/Path%5FTraversal)  
[OS Command Injection, Path Traversal & Local File Inclusion Vulnerability - Notes](https://riseandhack.blogspot.com/2015/02/os-command-injection-path-traversal.html)

Source: [Security Code Scan](https://security-code-scan.github.io/#Rules)