<h2>Why is this an issue?</h2>
<p>A <a
href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement"><code>for</code></a> loop
is a fundamental programming construct used to execute a block of code repeatedly. However, if the loop’s condition is false before the first
iteration, the loop will never execute.</p>
<pre data-diff-id="1" data-diff-type="noncompliant">
for (int i = 0; i &lt; 0; i++)  // Noncompliant: the condition is always false, the loop will never execute
{
    // ...
}
</pre>
<p>Rewrite the loop to ensure the condition evaluates to <code>true</code> at least once.</p>
<pre data-diff-id="1" data-diff-type="compliant">
for (int i = 0; i &lt; 10; i++)  // Compliant: the condition is true at least once, the loop will execute
{
    // ...
}
</pre>
<p>This bug has the potential to cause unexpected outcomes as the loop might contain critical code that needs to be executed.</p>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a
  href="https://learn.microsoft.com/en-us/dotnet/csharp/language-reference/statements/iteration-statements#the-for-statement">The <code>for</code>
  statement</a> </li>
</ul>

