<h2>Why is this an issue?</h2>
<p>When you annotate a field with the <a href="https://learn.microsoft.com/en-us/dotnet/api/system.threadstaticattribute"><code>ThreadStatic</code>
attribute</a>, it is an indication that the value of this field is unique for each thread. But if you don’t mark the field as <code>static</code>,
then the <code>ThreadStatic</code> attribute is ignored.</p>
<p>The <code>ThreadStatic</code> attribute should either be removed or replaced with the use of <a
href="https://learn.microsoft.com/en-us/dotnet/api/system.threading.threadlocal-1"><code>ThreadLocal&lt;T&gt;</code></a> class, which gives a similar
behavior for non-static fields.</p>
<h2>How to fix it</h2>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>
<pre>
public class MyClass
{
  [ThreadStatic]  // Noncompliant
  private int count = 0;

  // ...
}
</pre>
<h4>Compliant solution</h4>
<pre>
public class MyClass
{
  private int count = 0;

  // ...
}
</pre>
<p>or</p>
<pre>
public class MyClass
{
  private readonly ThreadLocal&lt;int&gt; count = new ThreadLocal&lt;int&gt;();
  public int Count
  {
    get { return count.Value; }
    set { count.Value = value; }
  }
  // ...
}
</pre>
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/system.threadstaticattribute">ThreadStaticAttribute Class</a> </li>
  <li> Microsoft Learn - <a href="https://learn.microsoft.com/en-us/dotnet/api/system.threading.threadlocal-1">ThreadLocal&lt;T&gt; Class</a> </li>
</ul>

