﻿## SA1010

<table>
<tr>
  <td>TypeName</td>
  <td>SA1010OpeningSquareBracketsMustBeSpacedCorrectly</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1010</td>
</tr>
<tr>
  <td>Category</td>
  <td>Spacing Rules</td>
</tr>
</table>

## Cause

An opening square bracket within a C# statement is not spaced correctly.

## Rule description

A violation of this rule occurs when an opening square bracket within a statement is preceded or followed by whitespace.

An opening square bracket should never be preceded by whitespace, unless it is the first character on the line, and an opening square should never be followed by whitespace, unless it is the last character on the line.

## How to fix violations

To fix a violation of this rule, ensure that there is no whitespace on either side of the opening square bracket.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.SpacingRules", "SA1010:OpeningSquareBracketsMustBeSpacedCorrectly", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1010 // OpeningSquareBracketsMustBeSpacedCorrectly
#pragma warning restore SA1010 // OpeningSquareBracketsMustBeSpacedCorrectly
```
