﻿## SA1108

<table>
<tr>
  <td>TypeName</td>
  <td>SA1108BlockStatementsMustNotContainEmbeddedComments</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1108</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A C# statement contains a comment between the declaration of the statement and the opening brace of the statement.

## Rule description

A violation of this rule occurs when the code contains a comment in between the declaration and the opening brace. For example:

```csharp
if (x != y)
// Make sure x does not equal y
{
}
```

The comment can legally be placed above the statement, or within the body of the statement:

```csharp
// Make sure x does not equal y
if (x != y)
{
}

if (x != y)
{
    // Make sure x does not equal y
}
```

If the comment is being used to comment out a line of code, begin the comment with four forward slashes rather than two:

```csharp
if (x != y)
////if (x == y)
{
}
```

## How to fix violations

To fix a violation of this rule, move the comment above the statement, within the body of the statement, or remove the comment.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1108:BlockStatementsMustNotContainEmbeddedComments", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1108 // BlockStatementsMustNotContainEmbeddedComments
#pragma warning restore SA1108 // BlockStatementsMustNotContainEmbeddedComments
```
