﻿## SA1113

<table>
<tr>
  <td>TypeName</td>
  <td>SA1113CommaMustBeOnSameLineAsPreviousParameter</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1113</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

A comma between two parameters in a call to a C# method or indexer, or in the declaration of a method or indexer, is not placed on the same line as the previous parameter.

## Rule description

A violation of this rule occurs when a comma between two parameters to a method or indexer is not placed on the same line as the previous parameter. The following examples show correct placement of the comma:

```csharp
public string JoinName(string first, string last)
{
    string name = JoinStrings(
        first, 
        last);
}

public int this[int x, 
   int y]
{
    get { return this.items[x, y]; }
}
```

## How to fix violations

To fix a violation of this rule, ensure that the comma is placed on the same line as the previous parameter.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1113:CommaMustBeOnSameLineAsPreviousParameter", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1113 // CommaMustBeOnSameLineAsPreviousParameter
#pragma warning restore SA1113 // CommaMustBeOnSameLineAsPreviousParameter
```
