﻿## SA1120

<table>
<tr>
  <td>TypeName</td>
  <td>SA1120CommentsMustContainText</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1120</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The C# comment does not contain any comment text.

## Rule description

A violation of this rule occurs whenever the code contains a C# comment which does not contain any text.

## How to fix violations

To fix a violation of this rule, add text to the comment, or remove the comment.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1120:CommentsMustContainText", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1120 // CommentsMustContainText
#pragma warning restore SA1120 // CommentsMustContainText
```
