﻿## SA1124

<table>
<tr>
  <td>TypeName</td>
  <td>SA1124DoNotUseRegions</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1124</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The C# code contains a region.

## Rule description

A violation of this rule occurs whenever a region is placed anywhere within the code. In many editors, including Visual Studio, the region will appear collapsed by default, hiding the code within the region. It is generally a bad practice to hide code, as this can lead to bad decisions as the code is maintained over time.

## How to fix violations

To fix a violation of this rule, remove the region from the code.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1124:DoNotUseRegions", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1124 // DoNotUseRegions
#pragma warning restore SA1124 // DoNotUseRegions
```
