﻿## SA1125

<table>
<tr>
  <td>TypeName</td>
  <td>SA1125UseShorthandForNullableTypes</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1125</td>
</tr>
<tr>
  <td>Category</td>
  <td>Readability Rules</td>
</tr>
</table>

## Cause

The Nullable type has been defined not using the C# shorthand. For example, `Nullable<DateTime>` has been used instead of the preferred `DateTime?`

## Rule description

A violation of this rule occurs whenever the Nullable type has been defined without using the shorthand C# style.

## How to fix violations

To fix a violation of this rule, use the shorthand version of the nullable type ie. int?, DateTime?, etc.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.ReadabilityRules", "SA1125:UseShorthandForNullableTypes", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1125 // UseShorthandForNullableTypes
#pragma warning restore SA1125 // UseShorthandForNullableTypes
```
