﻿## SA1206

<table>
<tr>
  <td>TypeName</td>
  <td>SA1206DeclarationKeywordsMustFollowOrder</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1206</td>
</tr>
<tr>
  <td>Category</td>
  <td>Ordering Rules</td>
</tr>
</table>

## Cause

The keywords within the declaration of an element do not follow a standard ordering scheme.

## Rule description

A violation of this rule occurs when the keywords within an element's declaration do not follow a standard ordering scheme.

Within an element declaration, keywords should appear in the following order:

*Access modifiers*

*static*

*All other keywords*



Using a standard ordering scheme for element declaration keywords can make the code more readable by highlighting the access level of each element. This can help prevent elements from being given a higher access level than needed.

## How To Fix Violations

To fix an instance of this violation, order the keywords in the element's declaration as described above.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.OrderingRules", "SA1206:DeclarationKeywordsMustFollowOrder", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1206 // DeclarationKeywordsMustFollowOrder
#pragma warning restore SA1206 // DeclarationKeywordsMustFollowOrder
```
