﻿## SA1516

<table>
<tr>
  <td>TypeName</td>
  <td>SA1516ElementsMustBeSeparatedByBlankLine</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1516</td>
</tr>
<tr>
  <td>Category</td>
  <td>Layout Rules</td>
</tr>
</table>

## Cause

Adjacent C# elements are not separated by a blank line.

> :memo: The behavior of this rule can change based on the configuration of the `blankLinesBetweenUsingGroups` property in **stylecop.json**. See [Configuration.md](Configuration.md) for more information.

## Rule description

To improve the readability of the code, StyleCop requires blank lines in certain situations, and prohibits blank lines in other situations. This results in a consistent visual pattern across the code, which can improve recognition and readability of unfamiliar code.

A violation of this rule occurs when two adjacent element are not separated by a blank line. For example:

```csharp
public void Method1()
{
}
public bool Property
{
    get { return true; }
}
```

In the example above, the method and property are not separated by a blank line, so a violation of this rule would occur.

```csharp
public event EventHandler SomeEvent
{
    add
    {
        // add event subscriber here
    }
    remove
    {
        // remove event subscriber here
    }
}
```

In the example above, the add and remove of the event need to be separated by a blank line because the add is multiline.

## How to fix violations

To fix a violation of this rule, add a blank line between the adjacent elements.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.LayoutRules", "SA1516:ElementsMustBeSeparatedByBlankLine", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1516 // ElementsMustBeSeparatedByBlankLine
#pragma warning restore SA1516 // ElementsMustBeSeparatedByBlankLine
```
