﻿## SA1632

<table>
<tr>
  <td>TypeName</td>
  <td>SA1632DocumentationTextMustMeetMinimumCharacterLength</td>
</tr>
<tr>
  <td>CheckId</td>
  <td>SA1632</td>
</tr>
<tr>
  <td>Category</td>
  <td>Documentation Rules</td>
</tr>
</table>

:warning: This rule has been intentionally omitted from StyleCop Analyzers. See [KnownChanges.md](KnownChanges.md) for
additional information.

## Cause

From StyleCop 4.5 this rule is disabled by default.

A section of the Xml header documentation for a C# element is too short.

## Rule description

C# syntax provides a mechanism for inserting documentation for classes and elements directly into the code, through the use of Xml documentation headers. For an introduction to these headers and a description of the header syntax, see the following article: [https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments](https://docs.microsoft.com/en-us/dotnet/csharp/programming-guide/xmldoc/xml-documentation-comments).

A violation of this rule occurs when part of the documentation is too short. This can often indicate that the documentation is not descriptive. For example:

```csharp
/// <summary>
/// A name
/// </summary>
public class Name
{
    ...
}
```

## How to fix violations

To fix a violation of this rule, rewrite the documentation text using grammatically proper and descriptive language. In most cases, doing so will cause the length of the documentation text to be greater than the minimum length which causes this rule to fire.

## How to suppress violations

```csharp
[SuppressMessage("StyleCop.CSharp.DocumentationRules", "SA1632:DocumentationTextMustMeetMinimumCharacterLength", Justification = "Reviewed.")]
```

```csharp
#pragma warning disable SA1632 // DocumentationTextMustMeetMinimumCharacterLength
#pragma warning restore SA1632 // DocumentationTextMustMeetMinimumCharacterLength
```
