<p>This rule is deprecated, and will eventually be removed.</p>
<h2>Why is this an issue?</h2>
<p>Overriding the <code>Object.finalize()</code> method must be done with caution to dispose some system resources.</p>
<p>Calling the <code>super.finalize()</code> at the end of this method implementation is highly recommended in case parent implementations must also
dispose some system resources.</p>
<h3>Noncompliant code example</h3>

```java
protected void finalize() {   // Noncompliant; no call to super.finalize();
  releaseSomeResources();
}

protected void finalize() {
  super.finalize();  // Noncompliant; this call should come last
  releaseSomeResources();
}
```
<h3>Compliant solution</h3>

```java
protected void finalize() {
  releaseSomeResources();
  super.finalize();
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/568">CWE-568 - finalize() Method Without super.finalize()</a> </li>
  <li> <a href="https://wiki.sei.cmu.edu/confluence/x/4jZGBQ">CERT, MET12-J.</a> - Do not use finalizers </li>
</ul>