<h2>Why is this an issue?</h2>
<p>Using checked exceptions forces method callers to deal with errors, either by propagating them or by handling them. Throwing exceptions makes them
fully part of the API of the method.</p>
<p>But to keep the complexity for callers reasonable, methods should not throw more than one kind of checked exception.</p>
<h3>Noncompliant code example</h3>

```java
public void delete() throws IOException, SQLException {      // Noncompliant
  /* ... */
}
```
<h3>Compliant solution</h3>

```java
public void delete() throws SomeApplicationLevelException {
  /* ... */
}
```
<h3>Exceptions</h3>
<p>Overriding methods are not checked by this rule and are allowed to throw several checked exceptions.</p>