<h2>Why is this an issue?</h2>
<p>Generating random floating point values to cast them into integers is inefficient. A random bounded integer value can be generated with a single
proper method call. Use <code>nextInt</code> to make the code more efficient and the intent clearer.</p>
<h3>Noncompliant code example</h3>

```java
Random r = new Random();
int rand = (int) (r.nextDouble() * 50);  // Noncompliant way to get a pseudo-random value between 0 and 50
int rand2 = (int) r.nextFloat(); // Noncompliant; will always be 0;
```
<h3>Compliant solution</h3>

```java
Random r = new Random();
int rand = r.nextInt(50);  // returns pseudo-random value between 0 and 50
int rand2 = 0;
```