<h2>Why is this an issue?</h2>
<p>When boxed type <code>java.lang.Boolean</code> is used as an expression to determine the control flow (as described in <a
href="https://docs.oracle.com/javase/specs/jls/se8/html/jls-4.html#jls-4.2.5">Java Language Specification §4.2.5 The <code>boolean</code> Type and
boolean Values</a>) it will throw a <code>NullPointerException</code> if the value is <code>null</code> (as defined in <a
href="https://docs.oracle.com/javase/specs/jls/se8/html/jls-5.html#jls-5.1.8">Java Language Specification §5.1.8 Unboxing Conversion</a>).</p>
<p>It is safer to avoid such conversion altogether and handle the <code>null</code> value explicitly.</p>
<p>Note, however, that no issues will be raised for Booleans that have already been null-checked.</p>
<h3>Noncompliant code example</h3>

```java
Boolean b = getBoolean();
if (b) {  // Noncompliant, it will throw NPE when b == null
  foo();
} else {
  bar();
}
```
<h3>Compliant solution</h3>

```java
Boolean b = getBoolean();
if (Boolean.TRUE.equals(b)) {
  foo();
} else {
  bar();  // will be invoked for both b == false and b == null
}


Boolean b = getBoolean();
if(b != null){
  String test = b ? "test" : "";
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://docs.oracle.com/javase/specs/jls/se8/html/jls-5.html#jls-5.1.8">Java Language Specification §5.1.8 Unboxing Conversion</a>
  </li>
</ul>