<h2>Why is this an issue?</h2>
<p>Objects annotated with Mockito annotations <code>@Mock</code>,&nbsp;<code>@Spy</code>,&nbsp;<code>@Captor</code>,&nbsp;or <code>@InjectMocks</code>
need to be initialized explicitly.</p>
<p>There are several ways to do this:</p>
<ul>
  <li> Call <code>MockitoAnnotations.openMocks(this)</code> or&nbsp;<code>MockitoAnnotations.initMocks(this)</code>&nbsp;in a setup method </li>
  <li> Annotate test class with&nbsp;<code>@RunWith(MockitoJUnitRunner.class)</code>&nbsp;(JUnit 4) </li>
  <li> Annotate test class with&nbsp;<code>@ExtendWith(MockitoExtension.class)</code>&nbsp;(JUnit 5 Jupiter) </li>
  <li> Use&nbsp;<code>@Rule public MockitoRule rule = MockitoJUnit.rule();</code> </li>
</ul>
<p>Test using uninitialized mocks will fail.</p>
<p>Note that this only applies to annotated Mockito objects. It is not necessary to initialize objects instantiated via <code>Mockito.mock()</code> or
<code>Mockito.spy()</code>.</p>
<p>This rule raises an issue when a test class uses uninitialized mocks.</p>
<h3>Noncompliant code example</h3>

```java
public class FooTest { // Noncompliant: Mockito initialization missing
  @Mock private Bar bar;

  @Spy private Baz baz;

  @InjectMocks private Foo fooUnderTest;

  @Test
  void someTest() {
    // test something ...
  }

  @Nested
  public class Nested {
    @Mock
    private Bar bar;
  }
```
<h3>Compliant solution</h3>

```java
@RunWith(MockitoJUnitRunner.class)
public class FooTest {
  @Mock private Bar bar;
  // ...
}
```

```java
@ExtendWith(MockitoExtension.class)
public class FooTest {
  @Mock private Bar bar;
  // ...
}
```

```java
public class FooTest {
  @Rule
  public MockitoRule rule = MockitoJUnit.rule();

  @Mock private Bar bar;
  // ...
}
```

```java
public class FooTest {
  @Mock private Bar bar;
  // ...

  @BeforeEach
  void setUp() {
    MockitoAnnotations.openMocks(this);
  }
  // ...
}
```

```java
public class FooTest {
  @Mock private Bar bar;
  // ...

  @Before
  void setUp() {
    MockitoAnnotations.initMocks(this);
  }
  // ...
}
```

```java
@ExtendWith(MockitoExtension.class)
public class FooTest {
  @Nested
  public class Nested {
    @Mock
    private Bar bar;
  }
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://site.mockito.org/javadoc/current/org/mockito/MockitoAnnotations.html">Mockito documentation - MockitoAnnotations</a> </li>
  <li> <a href="https://site.mockito.org/javadoc/current/org/mockito/junit/MockitoRule.html">Mockito documentation - MockitoRule </a> </li>
</ul>