<h2>Why is this an issue?</h2>
<p>Possessive quantifiers in Regex patterns like below improve performance by eliminating needless backtracking:</p>

```java
?+ , *+ , ++ , {n}+ , {n,}+ , {n,m}+
```
<p>But because possessive quantifiers do not keep backtracking positions and never give back, the following sub-patterns should not match only similar
characters. Otherwise, possessive quantifiers consume all characters that could have matched the following sub-patterns and nothing remains for the
following sub-patterns.</p>
<h3>Noncompliant code example</h3>

```java
Pattern pattern1 = Pattern.compile("a++abc");       // Noncompliant, the second 'a' never matches
Pattern pattern2 = Pattern.compile("\\d*+[02468]"); // Noncompliant, the sub-pattern "[02468]" never matches
```
<h3>Compliant solution</h3>

```java
Pattern pattern1 = Pattern.compile("aa++bc");            // Compliant, for example it can match "aaaabc"
Pattern pattern2 = Pattern.compile("\\d*+(?<=[02468])"); // Compliant, for example it can match an even number like "1234"
```