<h2>Why is this an issue?</h2>
<p>The Java regex engine uses recursive method calls to implement backtracking. Therefore when a repetition inside a regular expression contains
multiple paths (i.e. the body of the repetition contains an alternation (<code>|</code>), an optional element or another repetition), trying to match
the regular expression can cause a stack overflow on large inputs. This does not happen when using a possessive quantifier (such as <code>*+</code>
instead of <code>*</code>) or when using a character class inside a repetition (e.g. <code>[ab]*</code> instead of <code>(a|b)*</code>).</p>
<p>The size of the input required to overflow the stack depends on various factors, including of course the stack size of the JVM. One thing that
significantly increases the size of the input that can be processed is if each iteration of the repetition goes through a chain of multiple constant
characters because such consecutive characters will be matched by the regex engine without invoking any recursion.</p>
<p>For example, on a JVM with a stack size of 1MB, the regex <code>(?:a|b)*</code> will overflow the stack after matching around 6000 characters
(actual numbers may differ between JVM versions and even across multiple runs on the same JVM) whereas <code>(?:abc|def)*</code> can handle around
15000 characters.</p>
<p>Since often times stack growth can’t easily be avoided, this rule will only report issues on regular expressions if they can cause a stack overflow
on realistically sized inputs. You can adjust the <code>maxStackConsumptionFactor</code> parameter to adjust this.</p>
<h3>Noncompliant code example</h3>

```java
Pattern.compile("(a|b)*"); // Noncompliant
Pattern.compile("(.|\n)*"); // Noncompliant
Pattern.compile("(ab?)*"); // Noncompliant
```
<h3>Compliant solution</h3>

```java
Pattern.compile("[ab]*"); // Character classes don't cause recursion the way that '|' does
Pattern.compile("(?s).*"); // Enabling the (?s) flag makes '.' match line breaks, so '|\n' isn't necessary
Pattern.compile("(ab?)*+"); // Possessive quantifiers don't cause recursion because they disable backtracking
```