<h2>Why is this an issue?</h2>
<p>Shared naming conventions allow teams to collaborate efficiently.</p>
<p>This rule raises an issue when a function or a method name does not match a provided regular expression.</p>
<p>For example, with the default regular expression <code>^[a-z][a-zA-Z0-9]*$</code>, the function:</p>

```js
function DoSomething(){...}  // Noncompliant
```
<p>should be renamed to</p>

```js
function doSomething(){...}
```
<h3>Exceptions</h3>
<p>This rule ignores React Functional Components, JavaScript functions named with a capital letter and returning a React element (JSX syntax).</p>

```js
function Welcome() { // Compliant by exception
  const greeting = 'Hello, World!';

  // ...

  return (
    <div className="Welcome">
      <p>{greeting}</p>
    </div>
  );
}
```