<h2>Why is this an issue?</h2>
<p>The ECMAScript specification defines a set of special words as future keywords of the language. They don’t have particular meaning for now, but
they might at some future time.</p>
<p>The list contains the following words:</p>
<ul>
  <li> <code>await</code> </li>
  <li> <code>class</code> </li>
  <li> <code>const</code> </li>
  <li> <code>enum</code> </li>
  <li> <code>export</code> </li>
  <li> <code>extends</code> </li>
  <li> <code>implements</code> </li>
  <li> <code>import</code> </li>
  <li> <code>interface</code> </li>
  <li> <code>let</code> </li>
  <li> <code>package</code> </li>
  <li> <code>private</code> </li>
  <li> <code>protected</code> </li>
  <li> <code>public</code> </li>
  <li> <code>static</code> </li>
  <li> <code>super</code> </li>
  <li> <code>yield</code> </li>
</ul>
<p>Some of these words have already been adopted by current versions of ECMAScript, but they are kept to consider legacy JavaScript codebases as well.
Others are only reserved when used in strict mode.</p>
<p>These future reserved words should be avoided because they may cause syntax errors if they are ever adopted.</p>

```js
const package = document.getElementsByName("foo"); // Noncompliant: `package` is used as an identifier here
```
<p>These future keywords can be used anywhere if it is not identifiers.</p>

```js
const someData = { package: true };                // Compliant: `package` is not used as an identifier here
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Lexical_grammar#future_reserved_words">Future
  reserved words</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Strict_mode">Strict mode</a> </li>
  <li> Wikipedia - <a href="https://en.wikipedia.org/wiki/Syntax_error">Syntax error</a> </li>
</ul>