<h2>Why is this an issue?</h2>
<p>Use a <code>+</code> with two numbers and you’ll get addition. But use it with a string and anything else, and you’ll get concatenation. This could
be confusing, especially if it’s not obvious that one of the operands is a string. It is recommended to explicitly convert the non-string component to
make it easier to understand to future maintainers.</p>
<p>This rule raises an issue when <code>+</code> or <code>+=</code> is used with a string and a non-string.</p>
<h3>Noncompliant code example</h3>

```js
function foo() {
  let x = 5 + 8;  // okay
  let z = "8"
  return x + z;  // Noncompliant; yields string "138"
}
```
<h3>Compliant solution</h3>

```js
function foo() {
  let x = 5 + 8;
  let z = "8"
  return x + Number(z);
}
```