<h2>Why is this an issue?</h2>
<p>When placing Unicode <a href="https://unicode.org/glossary/#grapheme_cluster">Grapheme Clusters</a> (characters which require to be encoded in
multiple <a href="https://unicode.org/glossary/#code_point">Code Points</a>) inside a character class of a regular expression, this will likely lead
to unintended behavior.</p>
<p>For instance, the grapheme cluster <code>c̈</code> requires two code points: one for <code>'c'</code>, followed by one for the <em>umlaut</em>
modifier <code>'\u{0308}'</code>. If placed within a character class, such as <code>[c̈]</code>, the regex will consider the character class being the
enumeration <code>[c\u{0308}]</code> instead. It will, therefore, match every <code>'c'</code> and every <em>umlaut</em> that isn’t expressed as a
single codepoint, which is extremely unlikely to be the intended behavior.</p>
<p>This rule raises an issue every time Unicode Grapheme Clusters are used within a character class of a regular expression.</p>
<h3>Noncompliant code example</h3>

```js
"cc̈d̈d".replace(/[c̈d̈]/g, "X"); // result is "XXXXXX" and not expected "cXXd"
```
<h3>Compliant solution</h3>

```js
"cc̈d̈d".replace(/c̈|d̈/g, "X"); // result is "cXXd"
```