<h2>Why is this an issue?</h2>
<p>Positive <code>tabIndex</code> values can disrupt the natural tab order of the webpage. This can be confusing for screen reader users who rely on a
logical tab order to navigate through the content. If the tab order doesn’t match the visual or logical order of elements, users may struggle to
understand the page structure.</p>
<p>Therefore, it’s recommended to avoid using positive <code>tabIndex</code> values.</p>
<h2>How to fix it</h2>
<p>If you need to make an element focusable that isn’t by default (like a <code>&lt;div&gt;</code> or <code>&lt;span&gt;</code>), you can use
<code>tabIndex="0"</code>. This will add the element to the natural tab order based on its position in the HTML. Otherwise, either remove the
<code>tabIndex</code> value or use <code>tabIndex="-1"</code> to remove the element from the tab order.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```js
function MyDiv() {
    return (
        <div>
            <span tabIndex="5">foo</span> // Noncompliant
            <span tabIndex="3">bar</span> // Noncompliant
            <span tabIndex="1">baz</span> // Noncompliant
            <span tabIndex="2">qux</span> // Noncompliant
        </div>
    );
}
```
<h4>Compliant solution</h4>

```js
function MyDiv() {
    return (
        <div>
            <span tabIndex="0">foo</span>
            <span tabIndex="-1">bar</span>
            <span tabIndex={0}>baz</span>
            <span>qux</span>
        </div>
    );
}
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/HTML/Global_attributes/tabindex">tabindex</a> </li>
  <li> WCAG - <a href="https://www.w3.org/WAI/WCAG21/Understanding/focus-order">Focus Order</a> </li>
</ul>