<p>Once control flow has been moved out of the current code block, any subsequent statements become effectively unreachable.</p>
<h2>Why is this an issue?</h2>
<p>Jump statements (<code>return</code>, <code>break</code> and <code>continue</code>) move control flow out of the current code block. So any
statements that come after a jump are dead code.</p>
<h3>Noncompliant code example</h3>

```kotlin
fun foo(a: Int): Int {
  var i = 10;
  return a + i;       // Noncompliant
  i++;                // dead code
}
```
<h3>Compliant solution</h3>

```kotlin
fun foo(a: Int): Int {
  var i = 10;
  return a + i;
}
```
<h2>Resources</h2>
<ul>
  <li> <a href="https://cwe.mitre.org/data/definitions/561">MITRE, CWE-561</a> - Dead Code </li>
</ul>