<h2>Why is this an issue?</h2>
<p>Shared coding conventions make it possible to collaborate efficiently. This rule makes it mandatory to place the open curly brace at the beginning
of a line.</p>
<h3>Noncompliant code example</h3>

```php
function myMethod() {  // Noncompliant
  if(something) {  // Noncompliant
    executeTask();
  } else {  //Noncompliant
    doSomethingElse();
  }
}
```
<h3>Compliant solution</h3>

```php
function myMethod()
{
  if(something)
  {
    executeTask();
  } else
  {
    doSomethingElse();
  }
}
```