<h2>Why is this an issue?</h2>
<p>The requirement for a final <code>case default</code> clause is defensive programming. The clause should either take appropriate action, or contain
a suitable comment as to why no action is taken. Even when the <code>switch</code> covers all current values of an <code>enum</code>, a default case
should still be used because there is no guarantee that the <code>enum</code> won’t be extended.</p>
<h3>Noncompliant code example</h3>

```php
switch ($param) {  //missing default clause
  case 0:
    do_something();
    break;
  case 1:
    do_something_else();
    break;
}
```
<h3>Compliant solution</h3>

```php
switch ($param) {
  case 0:
    do_something();
    break;
  case 1:
    do_something_else();
    break;
  default:
    error();
    break;
}
```
<h2>Resources</h2>
<ul>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/478">CWE-478 - Missing Default Case in Switch Statement</a> </li>
</ul>