<h2>Why is this an issue?</h2>
<p>A <code>catch</code> clause that only rethrows the caught exception has the same effect as omitting the <code>catch</code> altogether and letting
it bubble up automatically.</p>

```php
$s = "";
try {
  $s = readMyFile($fileName);
} catch (Exception $e)  {
  throw $e;  // Noncompliant
}
```
<p>Such clauses should either be removed or populated with the appropriate logic.</p>

```php
$s = readMyFile($fileName);
```
<p>or</p>

```php
$s = "";
try {
  $s = readMyFile($fileName);
} catch (Exception $e) {
  error_log($e->getMessage());
  throw new MyException("an exception occurred", 2, $e);
}
```