<p>File access functions in PHP are typically used to open local files. They are also capable of reading files from remote servers using protocols
such as HTTP, HTTPS and FTP.</p>
<p>This behavior is controlled by the <code>allow_url_fopen</code> and <code>allow_url_include</code> settings.</p>
<h2>Why is this an issue?</h2>
<p>Most applications do not require or expect the file access functions to download remotely accessible files. However, attackers can abuse these
remote file access features while exploiting other vulnerabilities, such as path traversal issues.</p>
<h3>What is the potential impact?</h3>
<p>While activating these settings does not pose a direct threat to the application’s security, they can make the exploitation of other
vulnerabilities easier and more severe.</p>
<p>If an attacker can control a file location while <code>allow_url_fopen</code> is set to <code>1</code>, they can use this ability to perform a
Server-Side Request Forgery exploit. This allows the attacker to affect more than just the local application and they may be able to laterally attack
other assets on the local network.</p>
<p>If <code>allow_url_include</code> is set to <code>1</code>, the attacker will also have the ability to download and execute arbitrary PHP code.</p>
<h2>How to fix it</h2>
<p><code>allow_url_fopen</code> and <code>allow_url_include</code> should be deactivated in the main PHP configuration file. Note that
<code>allow_url_include</code> is disabled by default while <code>allow_url_fopen</code> is not and must be explicitly disabled.</p>
<h3>Code examples</h3>
<h4>Noncompliant code example</h4>

```php
; php.ini  Noncompliant; allow_url_fopen is enabled by default
allow_url_include=1  ; Noncompliant
```
<h4>Compliant solution</h4>

```php
; php.ini
allow_url_fopen=0
allow_url_include=0
```
<h2>Resources</h2>
<h3>Standards</h3>
<ul>
  <li> OWASP - <a href="https://owasp.org/Top10/A05_2021-Security_Misconfiguration/">Top 10 2021 Category A5 - Security Misconfiguration</a> </li>
  <li> OWASP - <a href="https://owasp.org/www-project-top-ten/2017/A6_2017-Security_Misconfiguration">Top 10 2017 Category A6 - Security
  Misconfiguration</a> </li>
  <li> CWE - <a href="https://cwe.mitre.org/data/definitions/829">CWE-16 - Inclusion of Functionality from Untrusted Control Sphere</a> </li>
</ul>