<h2>Why is this an issue?</h2>
<p>An assertion is a statement within the unit test that checks whether a particular condition is true or false. It defines the expected behavior of
the unit being tested. Assertions are used to express the test’s expected outcome, and they are the criteria against which the actual output of the
unit is evaluated.</p>
<p>When the unit test is executed, the assertions are evaluated. If all the assertions in the test pass, it means the unit is functioning correctly
for that specific set of inputs. If any of the assertions fail, it indicates that there is a problem with the unit’s implementation, and the test case
helps identify the issue.</p>
<p>Without assertions, a unit test doesn’t actually verify anything, making it ineffective in catching potential bugs or regressions. It will always
pass, regardless of the implementation of the unit. This can lead to a false sense of security, as you may believe that your code is working correctly
when it might not be.</p>
<p>This rule raises an issue when one of the following assertion libraries is imported but no assertion is used in a test:</p>
<ul>
  <li> <code>chai</code> </li>
  <li> <code>sinon</code> </li>
  <li> <code>vitest</code> </li>
  <li> <code>supertest</code> </li>
</ul>

```ts
const expect = require("chai").expect;

describe("No assertions", function() {
    it("don't test anything", function() { // Noncompliant: The unit test doesn't assert anything
        const str = "";
    });
});
```
<p>To write effective unit tests, you should define the expected behavior of the unit using assertions, allowing you to catch bugs early and ensure
the reliability of your codebase.</p>

```ts
const expect = require("chai").expect;

describe("Assertions", function() {
    it("test something", function() {
        const str = "";
        expect(str).to.be.a("string");
    });
});
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> Chai.js Documentation - <a href="https://www.chaijs.com/api/">API Reference</a> </li>
  <li> Sinon.js Documentation - <a href="https://sinonjs.org/releases/latest/assertions/">Assertions</a> </li>
</ul>