<h2>Why is this an issue?</h2>
<p>The <code>void</code> operator evaluates its argument and always returns <code>undefined</code>. <code>void</code> allows using any expression
where an <code>undefined</code> is expected. However, using <code>void</code> makes code more difficult to understand, as the intent is often
unclear.</p>

```ts
if (parameter === void 42) { // Noncompliant
   // ...
}
doSomethingElse(void doSomething()); // Noncompliant
```
<p>Instead of using <code>void</code> to get the <code>undefined</code> value, use the <code>undefined</code> global property. In ECMAScript5 and
newer environments, <code>undefined</code> cannot be reassigned. In other cases, remove the <code>void</code> operator to avoid confusion for
maintainers.</p>

```ts
if (parameter === undefined) {
   // ...
}
doSomething();
doSomethingElse();
```
<h3>Exceptions</h3>
<ul>
  <li> <code>void 0</code> (or the equivalent <code>void(0)</code>) is allowed as it was a conventional way to obtain the <code>undefined</code> value
  in environments before ECMAScript 5. </li>
</ul>

```ts
if (parameter === void 0) {
   // ...
}
```
<ul>
  <li> <code>void</code> is allowed with immediately invoked function expressions. </li>
</ul>

```ts
void function() {
   // ...
}();
```
<ul>
  <li> <code>void</code> is allowed with Promise-like objects to mark a promise as intentionally not awaited, as advised by <a
  href="https://github.com/typescript-eslint/typescript-eslint/blob/main/packages/eslint-plugin/docs/rules/no-floating-promises.mdx">@typescript-eslint/no-floating-promises</a>. </li>
</ul>

```ts
const runPromise = () => Promise.resolve();
void runPromise();
```
<h2>Resources</h2>
<h3>Documentation</h3>
<ul>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/void"><code>void</code> operator</a> </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/undefined"><code>undefined</code></a>
  </li>
  <li> MDN web docs - <a href="https://developer.mozilla.org/en-US/docs/Glossary/IIFE">IIFE (Immediately Invoked Function Expression)</a> </li>
</ul>